% VIAM DOCUMENT STYLE 
% Released 22 January 2015 
% Modified 1  July    2025
%    for LaTeX2e
% Author: Mikheil Rukhaia
% Version: 1.1
% Copyright (C) 2014-2025 by VIAM

\ProvidesClass{viamax}
\NeedsTeXFormat{LaTeX2e}

%% Load base
\LoadClass[12pt,twoside]{article}

\RequirePackage{amssymb}
\RequirePackage{amsfonts}
\RequirePackage{amsbsy}
\RequirePackage{amsmath}
\RequirePackage{amsthm}
\RequirePackage{etoolbox}
%\RequirePackage{epstopdf}
\RequirePackage{fancyhdr}
\RequirePackage{graphicx}
\RequirePackage{textcase}
\RequirePackage{url}

%% Page layout
\setlength\textwidth      {455pt} 
\setlength\textheight     {620pt}
\setlength\headheight     {15pt}
\setlength\topmargin      {0cm}
\setlength\oddsidemargin  {10pt} 
\setlength\evensidemargin {0cm}

%% Title and header
\def\@authorrunning{}
\def\authorrunning#1{\def\@authorrunning{#1}}
\def\@titlerunning{}
\def\titlerunning#1{\def\@titlerunning{#1}}
\def\@thanks{}
\def\thanks#1{\def\@thanks{\footnote{#1}}}

\fancypagestyle{firstpage}{%
\fancyhf{} % clear all six fields
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
}
\fancypagestyle{followingpage}{%
\fancyhf{} % clear all six fields
\fancyhead[CE]{\@authorrunning}
\fancyhead[CO]{{\it \@titlerunning}}
\fancyhead[LE,RO]{\thepage}
\renewcommand{\headrulewidth}{0.5pt}
\renewcommand{\footrulewidth}{0pt}
}
\pagestyle{followingpage}


\def\show@viamTitle{\vspace*{-1.85cm}%
  \vbox{\hbox to 1\hsize{\ Reports of Enlarged Sessions of the\hfill }
     \hbox to 1\hsize{\ Seminar of I. Vekua Institute\hfill}
     \hbox to 1\hsize{\ of Applied Mathematics\hfill}
     \hbox to 1\hsize{\ Volume {\@nom} \hfill} }
}

\def\maketitle{\thispagestyle{firstpage}\setcounter{section}{0}%
 \show@viamTitle\par\vspace*{0.4cm}
  \begingroup
    \let\footnotesize\small \let\footnoterule\relax%
    \def\@fnsymbol{\ensuremath{\star}}
    \def\thefootnote{\@fnsymbol}% change footnote symbol
    \begin{center}%
      {\MakeTextUppercase{\@title}~\@thanks \par}%
      \vspace*{0.3cm}%
      \begin{tabular}[t]{c}%
	\@author
      \end{tabular}\par%
    \end{center}%
    \par\vspace*{0.2cm}
  \endgroup
  \setcounter{footnote}{0}% reset footnote counter
  \setcounter{equation}{0}% reset equation counter
  \setcounter{figure}{0}% reset figure counter
  \setcounter{table}{0}% reset table counter
}

%% Generate additional information
\let\authlist\@empty
\def\authorInfo#1#2#3#4{%
  \listadd{\authlist}{%
    {\noindent#1\par% Name
    \noindent#2\par% Affiliation
    \noindent#3\par% Address
    \noindent E-mail: #4\par}
  }
}

\def\@received{}
\def\@revised{}
\def\@accepted{}
\def\received#1#2#3{\def\@received{#1}\def\@revised{#2}\def\@accepted{#3}}
\def\@nom{}
\def\nom#1{\def\@nom{#1}}

\def\makeAuthorInfo{\begingroup\footnotesize
  \vspace*{0.5cm}\noindent 
  Received \@received; 
  \ifdefempty{\@revised}{}{revised \@revised;}
  accepted \@accepted.\par
  \bigskip\noindent
  Author(s) address(es):\par\narrower %uncomment to indent the list
  \def\do{\par\bigskip}
  \dolistloop{\authlist}
  \global\let\authlist\@empty
  \endgroup\normalsize\relax
}

%% Special paragraphs
\newcommand{\namedparagraph}[3][:]{\par\vspace*{0.25cm}
  \noindent{\small {\bf #2}#1 #3}\par
}  

\def\abstract#1{\namedparagraph[.]{Abstract}{#1}}

\def\keywords#1{\namedparagraph{Keywords and phrases}{#1}}

\def\classification#1{\namedparagraph{AMS subject classification (2020)}{#1}}

%% Section
\def\section{\@startsection {section}{1}{\parindent}%
{3.25ex \@plus1ex \@minus .2ex}%
{-1em}%
{\normalfont\normalsize\bfseries}}
\def\subsection{\@startsection{subsection}{1}{1.5\parindent}%
{3.25ex \@plus1ex \@minus .2ex}%
{-1em}%
{\normalfont\normalsize\bfseries}}
\def\subsubsection{\@startsection{subsubsection}{1}{2.0\parindent}%
{3.25ex \@plus1ex \@minus .2ex}%
{-1em}%
{\normalfont\normalsize\bfseries}}
\def\paragraph{\@startsection{paragraph}{1}{2.5\parindent}%
{3.25ex \@plus1ex \@minus .2ex}%
{-1em}%
{\normalfont\normalsize\bfseries}}
\def\subparagraph{\@startsection{subparagraph}{1}{3.0\parindent}%
{3.25ex \@plus1ex \@minus .2ex}%
{-1em}%
{\normalfont\normalsize\bfseries}}

%% Bibliography
\bibliographystyle{acm}% this style formats @INPROCEEDINGS best
\renewcommand{\@biblabel}[1]{\hfill#1.}% removes [] in bibliography enumeration

\def\bibsection{\@startsection{section}{1}{0.35\textwidth}%
{-3.5ex \@plus -1ex \@minus -.2ex}%
{2.3ex \@plus.2ex}%
{\normalfont\footnotesize\bfseries}}

\def\bibname{{R E F E R E N C E S}}

\def\thebibliography#1{\footnotesize
  \bibsection*{\bibname}
  \list
  {\@biblabel{\arabic{enumiv}}}{\settowidth\labelwidth{\@biblabel{#1}}%
  \leftmargin\labelwidth
  \advance\leftmargin\labelsep
  \usecounter{enumiv}%
  \let\p@enumiv\@empty
  \def\theenumiv{\arabic{enumiv}}}%
  \def\newblock{\hskip .11em plus.33em minus.07em}%
  \sloppy\clubpenalty4000\widowpenalty4000
  \sfcode`\.=\@m
}

\def\endthebibliography{%
  \def\@noitemerr{\@warning{Empty `thebibliography' environment}}%
  \endlist}

%% Theorems  
\theoremstyle{definition}
\newtheorem{definition}{Definition}
\newtheorem{example}{Example}
\newtheorem{remark}{Remark}
\theoremstyle{plain}
\newtheorem{theorem}{Theorem}
\newtheorem{lemma}{Lemma}
\newtheorem{conjecture}{Conjecture}
\newtheorem{corollary}{Corollary}
\newtheorem{proposition}{Proposition}
  
\endinput
